function o = pssetactivelayer(n)
%PSSETACTIVELAYER    Activate the current layer in the current document.
%   The return value is the name of the previously selected layer. 
%
%   Example:
%   o = pssetactivelayer('Layer 4')
%
%   See also PSLAYERNAMES, PSNUMLAYERS, PSNEWLAYER, PSNEWLAYERMATRIX

%   Thomas Ruark, 2/23/2006
%   Copyright 2006 Adobe Systems Incorporated

% build up JavaScript to send to Photoshop
pstext = ['var o = "";' ...
    'var result = "";' ...
    'try {' ...
    '    o = app.activeDocument.activeLayer.name;' ...
    '    app.activeDocument.activeLayer = app.activeDocument.layers["' n '"];' ...
    '    result = "OK";' ...
    '}' ...
    'catch(e) {' ...
    '    o = e.toString();' ...
    '    result = "FAIL";' ...
    '}' ...
    'var b = result + o;' ...
    'b;'];

psresult = psjavascriptu(pstext);

lo = strfind(psresult, 'OK');

if isempty(lo)
    error(psresult(length('FAIL') + 1:end));
else
    o = psresult(length('OK') + 1:end);
end
